#include <iostream>
#include <vector>
#include <unordered_map>
#include <algorithm>

using namespace std;

int main() {
    long long n;
    cin >> n;
    vector<long long> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i];
    }

    unordered_map<long long, long long> prefix_sum_index;
    prefix_sum_index[0] = -1; 
    long long current_sum = 0;
    long long najduziPodniz = 0;
    long long pocetak = -1;
    long long kraj = -1;

    for (long long i = 0; i < n; i++) {
        current_sum += a[i];
        if (prefix_sum_index.count(current_sum)) {
            long long duzina = i - prefix_sum_index[current_sum];
            if (duzina > najduziPodniz) {
                najduziPodniz = duzina;
                pocetak = prefix_sum_index[current_sum] + 1;
                kraj = i;
            }
        } else {
            prefix_sum_index[current_sum] = i;
        }
    }

    long long najcesci = 0;
    if (najduziPodniz > 0) {
        unordered_map<long long, long long> frekvencije;
        for (long long i = pocetak; i <= kraj; i++) {
            frekvencije[a[i]]++;
            najcesci = max(najcesci, frekvencije[a[i]]);
        }
    }

    cout << najcesci << endl;

    return 0;
}